/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.network;

import java.util.Map;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import me.angel.challenges6t4.network.ChallengeNetworking;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class ChallengeNetworkingClient {
    public static void registerClientNetworking() {
        PayloadTypeRegistry.playS2C().register(ChallengeNetworking.ChallengeSyncPayload.ID, ChallengeNetworking.ChallengeSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ChallengeNetworking.ChallengeUpdatePayload.ID, ChallengeNetworking.ChallengeUpdatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ChallengeNetworking.ChallengeOptionsUpdatePayload.ID, ChallengeNetworking.ChallengeOptionsUpdatePayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ChallengeNetworking.ChallengeSyncPayload.ID, (payload, context) -> context.client().execute(() -> {
            for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                Boolean enabled = payload.challengeStates().get(challenge.getId());
                if (enabled == null) continue;
                challenge.setEnabledClientSide(enabled);
            }
            for (Map.Entry entry : payload.challengeOptions().entrySet()) {
                String challengeId = (String)entry.getKey();
                Map options = (Map)entry.getValue();
                for (Map.Entry optionEntry : options.entrySet()) {
                    String optionKey = (String)optionEntry.getKey();
                    Object optionValue = optionEntry.getValue();
                    if (optionValue instanceof Boolean) {
                        ChallengeSettings.setBooleanOption(challengeId, optionKey, (Boolean)optionValue);
                        continue;
                    }
                    if (optionValue instanceof Integer) {
                        ChallengeSettings.setIntOption(challengeId, optionKey, (Integer)optionValue);
                        continue;
                    }
                    if (optionValue instanceof Float) {
                        ChallengeSettings.setFloatOption(challengeId, optionKey, ((Float)optionValue).floatValue());
                        continue;
                    }
                    if (optionValue instanceof Long) {
                        ChallengeSettings.setLongOption(challengeId, optionKey, (Long)optionValue);
                        continue;
                    }
                    if (!(optionValue instanceof String)) continue;
                    ChallengeSettings.setStringOption(challengeId, optionKey, (String)optionValue);
                }
            }
            System.out.println("Received challenge state sync from server - " + payload.challengeStates().size() + " challenges updated, " + payload.challengeOptions().size() + " challenge options updated");
        }));
    }

    public static void sendChallengeUpdate(String challengeId, boolean enabled) {
        ChallengeNetworking.ChallengeUpdatePayload payload = new ChallengeNetworking.ChallengeUpdatePayload(challengeId, enabled);
        ClientPlayNetworking.send((class_8710)payload);
        System.out.println("Sent challenge update to server: " + challengeId + " = " + enabled);
    }

    public static void sendOptionsUpdate(String challengeId, String optionKey, Object optionValue) {
        ChallengeNetworking.ChallengeOptionsUpdatePayload payload = new ChallengeNetworking.ChallengeOptionsUpdatePayload(challengeId, optionKey, optionValue);
        ClientPlayNetworking.send((class_8710)payload);
        System.out.println("Sent options update to server: " + challengeId + "." + optionKey + " = " + String.valueOf(optionValue));
    }
}

